%% HISCALE spectra scratch paper

 %% Averaging and Smoothing Lab ASOP Spectra
% cd('D:\Google Drive\MatlabScripts\Saved Data\HI-SCALE\Field Spectra');
% savedmats = {'6A 4-28 2016 - 1830 - 0430 cleaned.mat';'11A 5-5 2016 - 0800-2100 - Stg7 cleaned.mat';'11A 5-5 2016 - 0800-2100 - Stg8 cleaned.mat';'13A 5-7 2016 - 1100-1540 - Stg8 cleaned.mat';'17A 5-14 2016 - 1100-1515 - Stg7 cleaned.mat';'17A 5-14 2016 - 1100-1515 - Stg8 cleaned.mat'};
% 
% for k = 1:length(savedmats)
% 	clear specmat normspecmat energy minspec maxspec lowspec upspec stdspec avgspec meanspec
% 	
% 	load(savedmats{k});
% 	normspecmat = BackgroundFit_STXM(savedmats{k});
% 	
% 	df = size(normspecmat,1);
% 	
% 	meanspec = mean(normspecmat);
% 	maxspec = max(normspecmat);
% 	minspec = min(normspecmat);
% 	stdspec = std(normspecmat);
% 	upspec = meanspec + (stdspec .* tinv(0.975,df) ./ sqrt(df));
% 	lowspec = meanspec - (stdspec .* tinv(0.975,df) ./ sqrt(df));
% 	
% 	smoothedmat = fnplt(csaps(energy,meanspec));
% 	
% 	smooth_energy = smoothedmat(1,:);
% 	smooth_spec = smoothedmat(2,:);
% 	
% 	newfilename = [savedmats{k}(1:end-4), '_smooth.mat'];
% 	save(newfilename);
% 	
% end

%% Collecting All Smoothed Spectra into One Array
cd('E:\Google Drive\MatlabScripts\Saved Data\HI-SCALE\Field Spectra');
savedmats = {...
	'6A 4-28 2016 - 1830 - 0430 cleaned_smooth.mat';...
	'11A 5-5 2016 - 0800-2100 - Stg7 cleaned_smooth.mat';
	'11A 5-5 2016 - 0800-2100 - Stg8 cleaned_smooth.mat';
	'13A 5-7 2016 - 1100-1540 - Stg8 cleaned_smooth.mat';
	'17A 5-14 2016 - 1100-1515 - Stg7 cleaned_smooth.mat';
	'thief_ambientasop.mat';
	'thief_tar.mat'};
% 	'17A 5-14 2016 - 1100-1515 - Stg8 cleaned_smooth.mat'}; %these spectra are pretty noisy

% savedmats = {'ASOP_Bubbling_Clean_smooth_cal.mat';...
% 	'ASOP_Nebulizing_Clean_smooth_cal.mat';...
% 	'S1_Clean_smooth_cal.mat';...
% 	'S1_H2O2_Clean_smooth_cal.mat';...
% 	'S1_heat_Clean_smooth_cal.mat';...
% 	'S2_Clean_smooth_cal.mat';...
% 	'S2_H2O2_Clean_smooth_cal.mat';...
% 	'S2_heat_Clean_smooth_cal.mat';...
% 	'S3_Clean_smooth_cal.mat';...
% 	'SA3Dialysis_Clean_smooth_cal.mat';...
% 	'SA3Filtered_Clean_smooth_cal.mat'};

bigsmoothmat = [];
bigsmoothenergy = [];
for k = 1:length(savedmats)-2
	load(savedmats{k},'smooth_spec','smooth_energy','upspec','lowspec','energy');
	[energy_unique,unique_idxs] = unique(smooth_energy);
	spec_unique = smooth_spec(unique_idxs);
	
	
	
	try
		bigsmoothenergy = [bigsmoothenergy ; energy_unique];
		bigsmoothmat = [bigsmoothmat ; spec_unique];
		upspecmat(k,:) = interp1(energy,upspec,energy_unique);
		lowspecmat(k,:) = interp1(energy,lowspec,energy_unique);
	catch
		interpspec = interp1(energy_unique,spec_unique,bigsmoothenergy(1,:));
		bigsmoothenergy = [bigsmoothenergy ; bigsmoothenergy(1,:)];
		bigsmoothmat = [bigsmoothmat ; interpspec];
		upspecmat(k,:) = interp1(energy,upspec,bigsmoothenergy(1,:));
		lowspecmat(k,:) = interp1(energy,lowspec,bigsmoothenergy(1,:));
	end
end
load(savedmats{end});
load(savedmats{end-1});

%% Offset Plotting
legendlabels = {...
	'Apr 28, S7',...
	'May 5, S7',...
	'May 5, S8',...
	'May 7, S8',...
	'May 14, S7',...
	'Ambient ASOPs',...
	'Tar Balls'};
figure;
maxfig(gcf,1);
hold on;
oldorder = [1:3,5:7];
% oldorder = [1:11];
% neworder = [4,10,1,5,6,3,8,2,11,9];
for g = 1:numel(oldorder)
	
% 	if ismember(g,[1,2]);
% 		groupoffset = 0;
% 	elseif ismember(g,[3:5]);
% 			groupoffset = 1;
% 	elseif ismember(g,[6:7]);
% 			groupoffset = 2;
% 	elseif ismember(g,8);
% 			groupoffset = 3;
% 	elseif ismember(g,[9:10]);
% 			groupoffset = 4;
% 	end

	if g <4
		groupoffset = 0;
	elseif g == 4
		groupoffset = 0.3;
	elseif g == 5
		groupoffset = 1;
	%elseif g == 6
	%elseif g == 7
	end
	
	if g <=4
		plot(bigsmoothenergy(oldorder(g),:),bigsmoothmat(oldorder(g),:)+0.5.*g-0.42,'LineWidth',2.5);
		%plot(bigsmoothenergy(oldorder(g),:),upspecmat(oldorder(g),:)+0.5.*g-0.42,'LineWidth',1,'Color','k');
		%plot(bigsmoothenergy(oldorder(g),:),lowspecmat(oldorder(g),:)+0.5.*g-0.42,'LineWidth',1,'Color','k');
	elseif g == 5
		plot(ambasop_energy,ambasop_int+1,'LineWidth',2.5);	
	elseif g == 6
		plot(tar_energy,tar_int+0.2,'LineWidth',2.5);
	end
	
end
legend(legendlabels(oldorder),'Box','off');
% legend({'9','11','2','8','3','6','5','1','4','10'});
% legend({'4','10','1','5','6','3','8','2','11','9'});
axis square
xlim([278,320]);
ylim([0,6]);
xlabel('Energy (eV)');
% ylabel('Optical Density (Normalized)');
title('Ambient Spectra');
% set(gca,'FontWeight','bold','FontSize',20,'YTick',[0,1,2,3,4],'Color','none','LineWidth',2);
set(gca,'FontWeight','bold','FontSize',20,'YTick',[],'Color','none','LineWidth',2);

hv(1) = vline(285.2);
hv(2) = vline(286.7);
hv(3) = vline(288.5);
hv(4) = vline(290.4);
set(hv,'Color',[0.5,0.5,0.5]);
% vline(297.3);
% vline(299.9);


